﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['sl']={"application":"Rich Text Editor","editor":"Urejevalnik obogatenega besedila","editorPanel":"Plošča urejevalnika obogatenega besedila","common":{"editorHelp":"Pritisnite ALT 0 za pomoč","browseServer":"Prebrskaj na strežniku","url":"URL","protocol":"Protokol","upload":"Naloži","uploadSubmit":"Pošlji na strežnik","image":"Slika","form":"Obrazec","checkbox":"Potrditveno polje","radio":"Izbirno polje","textField":"Besedilno polje","textarea":"Besedilno območje","hiddenField":"Skrito polje","button":"Gumb","select":"Spustno polje","imageButton":"Slikovni gumb","notSet":"<ni določen>","id":"Id","name":"Ime","langDir":"Smer jezika","langDirLtr":"Od leve proti desni (LTR)","langDirRtl":"Od desne proti levi (RTL)","langCode":"Koda jezika","longDescr":"Dolg opis URL-ja","cssClass":"Razredi slogovne predloge","advisoryTitle":"Predlagani naslov","cssStyle":"Slog","ok":"V redu","cancel":"Prekliči","close":"Zapri","preview":"Predogled","resize":"Potegni za spremembo velikosti","generalTab":"Splošno","advancedTab":"Napredno","validateNumberFailed":"Vrednost ni število.","confirmNewPage":"Vse neshranjene spremembe vsebine bodo izgubljene. Ali res želite naložiti novo stran?","confirmCancel":"Spremenili ste nekaj možnosti. Ali res želite zapreti okno?","options":"Možnosti","target":"Cilj","targetNew":"Novo okno (_blank)","targetTop":"Vrhovno okno (_top)","targetSelf":"Isto okno (_self)","targetParent":"Starševsko okno (_parent)","langDirLTR":"Od leve proti desni (LTR)","langDirRTL":"Od desne proti levi (RTL)","styles":"Slog","cssClasses":"Razredi slogovne predloge","width":"Širina","height":"Višina","align":"Poravnava","left":"Levo","right":"Desno","center":"Sredinsko","justify":"Obojestranska poravnava","alignLeft":"Leva poravnava","alignRight":"Desna poravnava","alignCenter":"Align Center","alignTop":"Na vrh","alignMiddle":"V sredino","alignBottom":"Na dno","alignNone":"Brez poravnave","invalidValue":"Neveljavna vrednost.","invalidHeight":"Višina mora biti število.","invalidWidth":"Širina mora biti število.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"Vrednost, določena za polje »%1«, mora biti pozitivno število z ali brez veljavne CSS-enote za merjenje (px, %, in, cm, mm, em, ex, pt ali pc).","invalidHtmlLength":"Vrednost, določena za polje »%1«, mora biti pozitivno število z ali brez veljavne HTML-enote za merjenje (px ali %).","invalidInlineStyle":"Vrednost, določena za slog v vrstici, mora biti sestavljena iz ene ali več dvojic oblike »ime : vrednost«, ločenih s podpičji.","cssLengthTooltip":"Vnesite število za vrednost v slikovnih pikah ali število z veljavno CSS-enoto (px, %, in, cm, mm, em, ex, pt ali pc).","unavailable":"%1<span class=\"cke_accessibility\">, nedosegljiv</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Space","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Keyboard shortcut","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Vse pravice pridržane.","dlgTitle":"O programu CKEditor 4","moreInfo":"Za informacije o licenciranju prosimo obiščite našo spletno stran:"},"basicstyles":{"bold":"Krepko","italic":"Ležeče","strike":"Prečrtano","subscript":"Podpisano","superscript":"Nadpisano","underline":"Podčrtano"},"bidi":{"ltr":"Smer besedila od leve proti desni","rtl":"Smer besedila od desne proti levi"},"blockquote":{"toolbar":"Citat"},"notification":{"closed":"Notification closed."},"toolbar":{"toolbarCollapse":"Skrči orodno vrstico","toolbarExpand":"Razširi orodno vrstico","toolbarGroups":{"document":"Dokument","clipboard":"Odložišče/Razveljavi","editing":"Urejanje","forms":"Obrazci","basicstyles":"Osnovni slogi","paragraph":"Odstavek","links":"Povezave","insert":"Vstavi","styles":"Slogi","colors":"Barve","tools":"Orodja"},"toolbars":"Orodne vrstice urejevalnika"},"clipboard":{"copy":"Kopiraj","copyError":"Varnostne nastavitve brskalnika ne dopuščajo samodejnega kopiranja. Uporabite kombinacijo tipk na tipkovnici (Ctrl/Cmd+C).","cut":"Izreži","cutError":"Varnostne nastavitve brskalnika ne dopuščajo samodejnega izrezovanja. Uporabite kombinacijo tipk na tipkovnici (Ctrl/Cmd+X).","paste":"Prilepi","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Prilepi območje","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Samodejno","bgColorTitle":"Barva ozadja","colors":{"000":"Črna","800000":"Maroon","8B4513":"Saddle Brown","2F4F4F":"Dark Slate Gray","008080":"Teal","000080":"Navy","4B0082":"Indigo","696969":"Dark Gray","B22222":"Fire Brick","A52A2A":"Rjava","DAA520":"Golden Rod","006400":"Temno zelena","40E0D0":"Turkizna","0000CD":"Srednje modra","800080":"Škrlatna","808080":"Siva","F00":"Rdeča","FF8C00":"Temno oranžna","FFD700":"Zlata","008000":"Zelena","0FF":"Sinja","00F":"Modra","EE82EE":"Vijolična","A9A9A9":"Dim Gray","FFA07A":"Light Salmon","FFA500":"Oranžna","FFFF00":"Rumena","00FF00":"Lime","AFEEEE":"Pale Turquoise","ADD8E6":"Svetlo modra","DDA0DD":"Plum","D3D3D3":"Svetlo siva","FFF0F5":"Lavender Blush","FAEBD7":"Antique White","FFFFE0":"Svetlo rumena","F0FFF0":"Honeydew","F0FFFF":"Azure","F0F8FF":"Alice Blue","E6E6FA":"Lavender","FFF":"Bela","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Orange","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"Silver","7F8C8D":"Grayish Cyan","999":"Dark Gray"},"more":"Več barv ...","panelTitle":"Barve","textColorTitle":"Barva besedila"},"colordialog":{"clear":"Počisti","highlight":"Poudarjeno","options":"Možnosti barve","selected":"Izbrana barva","title":"Izberi barvo"},"templates":{"button":"Predloge","emptyListMsg":"(Ni pripravljenih predlog)","insertOption":"Zamenjaj trenutno vsebino","options":"Možnosti Predloge","selectPromptMsg":"Izberite predlogo, ki jo želite odpreti v urejevalniku<br>(trenutna vsebina bo izgubljena):","title":"Vsebinske predloge"},"contextmenu":{"options":"Možnosti kontekstnega menija"},"copyformatting":{"label":"Copy Formatting","notification":{"copied":"Formatting copied","applied":"Formatting applied","canceled":"Formatting canceled","failed":"Formatting failed. You cannot apply styles without copying them first."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Predlagani naslov","cssClassInputLabel":"Razredi slogovne predloge","edit":"Uredi div","inlineStyleInputLabel":"Slog v vrstici","langDirLTRLabel":"Od leve proti desni (LTR)","langDirLabel":"Smer jezika","langDirRTLLabel":"Od desne proti levi (RTL)","languageCodeInputLabel":"Koda jezika","remove":"Odstrani div","styleSelectLabel":"Slog","title":"Ustvari vsebnik div","toolbar":"Ustvari vsebnik div"},"elementspath":{"eleLabel":"Pot elementov","eleTitle":"Element %1"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Error occurred during file read.","networkError":"Network error occurred during file upload.","httpError404":"HTTP error occurred during file upload (404: File not found).","httpError403":"HTTP error occurred during file upload (403: Forbidden).","httpError":"HTTP error occurred during file upload (error status: %1).","noUrlError":"Upload URL is not defined.","responseError":"Incorrect server response."},"find":{"find":"Najdi","findOptions":"Možnosti iskanja","findWhat":"Najdi:","matchCase":"Razlikuj velike in male črke","matchCyclic":"Primerjaj znake v cirilici","matchWord":"Samo cele besede","notFoundMsg":"Navedenega besedila nismo našli.","replace":"Zamenjaj","replaceAll":"Zamenjaj vse","replaceSuccessMsg":"Zamenjali smo %1 pojavitev.","replaceWith":"Zamenjaj z:","title":"Najdi in zamenjaj"},"font":{"fontSize":{"label":"Velikost","voiceLabel":"Velikost pisave","panelTitle":"Velikost pisave"},"label":"Pisava","panelTitle":"Ime pisave","voiceLabel":"Pisava"},"fakeobjects":{"anchor":"Sidro","hiddenfield":"Skrito polje","iframe":"IFrame","unknown":"Neznan objekt"},"forms":{"button":{"title":"Lastnosti gumba","text":"Besedilo (Vrednost)","type":"Vrsta","typeBtn":"Gumb","typeSbm":"Potrdi","typeRst":"Ponastavi"},"checkboxAndRadio":{"checkboxTitle":"Lastnosti potrditvenega polja","radioTitle":"Lastnosti izbirnega polja","value":"Vrednost","selected":"Izbrano","required":"Zahtevano"},"form":{"title":"Lastnosti obrazca","menu":"Lastnosti obrazca","action":"Dejanje","method":"Metoda","encoding":"Kodiranje znakov"},"hidden":{"title":"Lastnosti skritega polja","name":"Ime","value":"Vrednost"},"select":{"title":"Lastnosti spustnega seznama","selectInfo":"Podatki","opAvail":"Razpoložljive izbire","value":"Vrednost","size":"Velikost","lines":"vrstic","chkMulti":"Dovoli izbor več vrednosti","required":"Zahtevano","opText":"Besedilo","opValue":"Vrednost","btnAdd":"Dodaj","btnModify":"Spremeni","btnUp":"Gor","btnDown":"Dol","btnSetValue":"Določi kot privzeto izbiro","btnDelete":"Izbriši"},"textarea":{"title":"Lastnosti besedilnega območja","cols":"Stolpcev","rows":"Vrstic"},"textfield":{"title":"Lastnosti besedilnega polja","name":"Ime","value":"Vrednost","charWidth":"Širina","maxChars":"Največje število znakov","required":"Zahtevano","type":"Vrsta","typeText":"Besedilo","typePass":"Geslo","typeEmail":"E-pošta","typeSearch":"Iskanje","typeTel":"Telefonska številka","typeUrl":"URL"}},"format":{"label":"Oblika","panelTitle":"Oblika odstavka","tag_address":"Napis","tag_div":"Navaden (DIV)","tag_h1":"Naslov 1","tag_h2":"Naslov 2","tag_h3":"Naslov 3","tag_h4":"Naslov 4","tag_h5":"Naslov 5","tag_h6":"Naslov 6","tag_p":"Navaden","tag_pre":"Oblikovan"},"horizontalrule":{"toolbar":"Vstavi vodoravno črto"},"iframe":{"border":"Pokaži obrobo okvirja","noUrl":"Prosimo, vnesite iframe URL","scrolling":"Omogoči drsnike","title":"Lastnosti IFrame","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Nadomestno besedilo","border":"Obroba","btnUpload":"Pošlji na strežnik","button2Img":"Želite pretvoriti izbrani gumb s sliko v preprosto sliko?","hSpace":"Vodoravni odmik","img2Button":"Želite pretvoriti izbrano sliko v gumb s sliko?","infoTab":"Podatki o sliki","linkTab":"Povezava","lockRatio":"Zakleni razmerje","menu":"Lastnosti slike","resetSize":"Ponastavi velikost","title":"Lastnosti slike","titleButton":"Lastnosti gumba s sliko","upload":"Naloži","urlMissing":"Manjka URL vira slike.","vSpace":"Navpični odmik","validateBorder":"Meja mora biti celo število.","validateHSpace":"Vodoravni odmik mora biti celo število.","validateVSpace":"VSpace mora biti celo število."},"indent":{"indent":"Povečaj zamik","outdent":"Zmanjšaj zamik"},"smiley":{"options":"Možnosti Smeška","title":"Vstavi smeška","toolbar":"Smeško"},"language":{"button":"Nastavi jezik","remove":"Odstrani jezik"},"link":{"acccessKey":"Tipka za dostop","advanced":"Napredno","advisoryContentType":"Predlagana vrsta vsebine","advisoryTitle":"Predlagani naslov","anchor":{"toolbar":"Sidro","menu":"Uredi sidro","title":"Lastnosti sidra","name":"Ime sidra","errorName":"Prosimo, vnesite ime sidra","errorWhitespace":"Anchor name cannot contain space characters","remove":"Odstrani sidro"},"anchorId":"Po ID-ju elementa","anchorName":"Po imenu sidra","charset":"Nabor znakov povezanega vira","cssClasses":"Razredi slogovne predloge","download":"Force Download","displayText":"Display Text","emailAddress":"E-poštni naslov","emailBody":"Telo sporočila","emailSubject":"Zadeva sporočila","id":"Id","info":"Podatki o povezavi","langCode":"Koda jezika","langDir":"Smer jezika","langDirLTR":"Od leve proti desni (LTR)","langDirRTL":"Od desne proti levi (RTL)","menu":"Uredi povezavo","name":"Ime","noAnchors":"(V tem dokumentu ni sider)","noEmail":"Vnesite e-poštni naslov","noUrl":"Vnesite URL povezave","noTel":"Please type the phone number","other":"<drugo>","phoneNumber":"Phone number","popupDependent":"Podokno (Netscape)","popupFeatures":"Značilnosti pojavnega okna","popupFullScreen":"Celozaslonsko (IE)","popupLeft":"Lega levo","popupLocationBar":"Naslovna vrstica","popupMenuBar":"Menijska vrstica","popupResizable":"Spremenljive velikosti","popupScrollBars":"Drsniki","popupStatusBar":"Vrstica stanja","popupToolbar":"Orodna vrstica","popupTop":"Lega na vrhu","rel":"Odnos","selectAnchor":"Izberite sidro","styles":"Slog","tabIndex":"Številka tabulatorja","target":"Cilj","targetFrame":"<okvir>","targetFrameName":"Ime ciljnega okvirja","targetPopup":"<pojavno okno>","targetPopupName":"Ime pojavnega okna","title":"Povezava","toAnchor":"Sidro na tej strani","toEmail":"E-pošta","toUrl":"URL","toPhone":"Phone","toolbar":"Vstavi/uredi povezavo","type":"Vrsta povezave","unlink":"Odstrani povezavo","upload":"Naloži"},"list":{"bulletedlist":"Vstavi/odstrani neoštevilčen seznam","numberedlist":"Vstavi/odstrani oštevilčen seznam"},"liststyle":{"bulletedTitle":"Bulleted List Properties","circle":"Circle","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disc","lowerAlpha":"Lower Alpha (a, b, c, d, e, etc.)","lowerRoman":"Lower Roman (i, ii, iii, iv, v, etc.)","none":"None","notset":"<not set>","numberedTitle":"Numbered List Properties","square":"Square","start":"Start","type":"Type","upperAlpha":"Upper Alpha (A, B, C, D, E, etc.)","upperRoman":"Upper Roman (I, II, III, IV, V, etc.)","validateStartNumber":"List start number must be a whole number."},"magicline":{"title":"Vstavite odstavek tukaj"},"maximize":{"maximize":"Maksimiraj","minimize":"Minimiraj"},"newpage":{"toolbar":"Nova stran"},"pagebreak":{"alt":"Prelom strani","toolbar":"Vstavi prelom strani"},"pastetext":{"button":"Prilepi kot golo besedilo","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Prilepi kot golo besedilo"},"pastefromword":{"confirmCleanup":"Besedilo, ki ga želite prilepiti, je kopirano iz Worda. Ali ga želite očistiti, preden ga prilepite?","error":"Ni bilo mogoče očistiti prilepljenih podatkov zaradi notranje napake","title":"Prilepi iz Worda","toolbar":"Prilepi iz Worda"},"preview":{"preview":"Predogled"},"print":{"toolbar":"Natisni"},"removeformat":{"toolbar":"Odstrani oblikovanje"},"save":{"toolbar":"Shrani"},"selectall":{"toolbar":"Izberi vse"},"showblocks":{"toolbar":"Prikaži ograde"},"sourcearea":{"toolbar":"Izvorna koda"},"specialchar":{"options":"Možnosti posebnih znakov","title":"Izberi posebni znak","toolbar":"Vstavi posebni znak"},"scayt":{"btn_about":"O storitvi SCAYT","btn_dictionaries":"Slovarji","btn_disable":"Onemogoči SCAYT","btn_enable":"Omogoči SCAYT","btn_langs":"Jeziki","btn_options":"Možnosti","text_title":"Črkovanje med tipkanjem"},"stylescombo":{"label":"Slog","panelTitle":"Oblikovalni Stili","panelTitle1":"Slogi odstavkov","panelTitle2":"Slogi besedila","panelTitle3":"Slogi objektov"},"table":{"border":"Velikost obrobe","caption":"Napis","cell":{"menu":"Celica","insertBefore":"Vstavi celico pred","insertAfter":"Vstavi celico za","deleteCell":"Izbriši celice","merge":"Združi celice","mergeRight":"Združi desno","mergeDown":"Združi navzdol","splitHorizontal":"Razdeli celico vodoravno","splitVertical":"Razdeli celico navpično","title":"Lastnosti celice","cellType":"Vrsta celice","rowSpan":"Razpon vrstic","colSpan":"Razpon stolpcev","wordWrap":"Prelom besedila","hAlign":"Vodoravna poravnava","vAlign":"Navpična poravnava","alignBaseline":"Osnovnica","bgColor":"Barva ozadja","borderColor":"Barva obrobe","data":"Podatki","header":"Glava","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Da","no":"Ne","invalidWidth":"Širina celice mora biti število.","invalidHeight":"Višina celice mora biti število.","invalidRowSpan":"Razpon vrstic mora biti celo število.","invalidColSpan":"Razpon stolpcev mora biti celo število.","chooseColor":"Izberi"},"cellPad":"Odmik znotraj celic","cellSpace":"Razmik med celicami","column":{"menu":"Stolpec","insertBefore":"Vstavi stolpec pred","insertAfter":"Vstavi stolpec za","deleteColumn":"Izbriši stolpce"},"columns":"Stolpci","deleteTable":"Izbriši tabelo","headers":"Glave","headersBoth":"Oboje","headersColumn":"Prvi stolpec","headersNone":"Brez","headersRow":"Prva vrstica","heightUnit":"height unit","invalidBorder":"Širina obrobe mora biti število.","invalidCellPadding":"Odmik znotraj celic mora biti pozitivno število.","invalidCellSpacing":"Razmik med celicami mora biti pozitivno število.","invalidCols":"Število stolpcev mora biti večje od 0.","invalidHeight":"Višina tabele mora biti število.","invalidRows":"Število vrstic mora biti večje od 0.","invalidWidth":"Širina tabele mora biti število.","menu":"Lastnosti tabele","row":{"menu":"Vrstica","insertBefore":"Vstavi vrstico pred","insertAfter":"Vstavi vrstico za","deleteRow":"Izbriši vrstice"},"rows":"Vrstice","summary":"Povzetek","title":"Lastnosti tabele","toolbar":"Tabela","widthPc":"odstotkov","widthPx":"pik","widthUnit":"enota širine"},"undo":{"redo":"Uveljavi","undo":"Razveljavi"},"widget":{"move":"Kliknite in povlecite, da premaknete","label":"%1 widget"},"uploadwidget":{"abort":"Upload aborted by the user.","doneOne":"File successfully uploaded.","doneMany":"Successfully uploaded %1 files.","uploadOne":"Uploading file ({percentage}%)...","uploadMany":"Uploading files, {current} of {max} done ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Izvorna koda","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Izvorna koda","title":"Izvorna koda"}};