﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['ar']={"application":"Rich Text Editor","editor":"محرر النص الغني","editorPanel":"لائحة محرر النص المنسق","common":{"editorHelp":"إضغط على ALT + 0 للحصول على المساعدة.","browseServer":"تصفح","url":"الرابط","protocol":"البروتوكول","upload":"رفع","uploadSubmit":"أرسل","image":"صورة","form":"نموذج","checkbox":"خانة إختيار","radio":"زر اختيار","textField":"مربع نص","textarea":"مساحة نصية","hiddenField":"إدراج حقل خفي","button":"زر ضغط","select":"اختار","imageButton":"زر صورة","notSet":"<بدون تحديد>","id":"الرقم","name":"إسم","langDir":"إتجاه النص","langDirLtr":"اليسار لليمين (LTR)","langDirRtl":"اليمين لليسار (RTL)","langCode":"رمز اللغة","longDescr":"الوصف التفصيلى","cssClass":"فئات التنسيق","advisoryTitle":"عنوان التقرير","cssStyle":"نمط","ok":"موافق","cancel":"إلغاء الأمر","close":"أغلق","preview":"استعراض","resize":"تغيير الحجم","generalTab":"عام","advancedTab":"متقدم","validateNumberFailed":"لايوجد نتيجة","confirmNewPage":"ستفقد أي متغييرات اذا لم تقم بحفظها اولا. هل أنت متأكد أنك تريد صفحة جديدة؟","confirmCancel":"بعض الخيارات قد تغيرت. هل أنت متأكد من إغلاق مربع النص؟","options":"خيارات","target":"هدف الرابط","targetNew":"نافذة جديدة","targetTop":"النافذة الأعلى","targetSelf":"داخل النافذة","targetParent":"النافذة الأم","langDirLTR":"اليسار لليمين (LTR)","langDirRTL":"اليمين لليسار (RTL)","styles":"نمط","cssClasses":"فئات التنسيق","width":"العرض","height":"الإرتفاع","align":"محاذاة","left":"يسار","right":"يمين","center":"وسط","justify":"ضبط","alignLeft":"محاذاة إلى اليسار","alignRight":"محاذاة إلى اليمين","alignCenter":"Align Center","alignTop":"أعلى","alignMiddle":"وسط","alignBottom":"أسفل","alignNone":"None","invalidValue":"قيمة غير مفبولة.","invalidHeight":"الارتفاع يجب أن يكون عدداً.","invalidWidth":"العرض يجب أن يكون عدداً.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"قيمة الخانة المخصصة لـ \"%1\" يجب أن تكون رقما موجبا، باستخدام أو من غير استخدام وحدة CSS قياس مقبولة (px, %, in, cm, mm, em, ex, pt, or pc).","invalidHtmlLength":"قيمة الخانة المخصصة لـ \"%1\" يجب أن تكون رقما موجبا، باستخدام أو من غير استخدام وحدة HTML قياس مقبولة (px or %).","invalidInlineStyle":"قيمة الخانة المخصصة لـ  Inline Style يجب أن تختوي على مجموع واحد أو أكثر بالشكل التالي: \"name : value\", مفصولة بفاصلة منقزطة.","cssLengthTooltip":"أدخل رقما للقيمة بالبكسل أو رقما بوحدة CSS مقبولة (px, %, in, cm, mm, em, ex, pt, or pc).","unavailable":"%1<span class=\"cke_accessibility\">, غير متاح</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Space","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Keyboard shortcut","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"حقوق النشر &copy; $1. جميع الحقوق محفوظة.","dlgTitle":"عن CKEditor","moreInfo":"للحصول على معلومات الترخيص ، يرجى زيارة موقعنا:"},"basicstyles":{"bold":"عريض","italic":"مائل","strike":"يتوسطه خط","subscript":"منخفض","superscript":"مرتفع","underline":"تسطير"},"bidi":{"ltr":"إتجاه النص من اليسار إلى اليمين","rtl":"إتجاه النص من اليمين إلى اليسار"},"blockquote":{"toolbar":"اقتباس"},"notification":{"closed":"Notification closed."},"toolbar":{"toolbarCollapse":"تقليص شريط الأدوت","toolbarExpand":"تمديد شريط الأدوات","toolbarGroups":{"document":"مستند","clipboard":"الحافظة/الرجوع","editing":"تحرير","forms":"نماذج","basicstyles":"نمط بسيط","paragraph":"فقرة","links":"روابط","insert":"إدراج","styles":"أنماط","colors":"ألوان","tools":"أدوات"},"toolbars":"أشرطة أدوات المحرر"},"clipboard":{"copy":"نسخ","copyError":"الإعدادات الأمنية للمتصفح الذي تستخدمه تمنع عمليات النسخ التلقائي. فضلاً إستخدم لوحة المفاتيح لفعل ذلك (Ctrl/Cmd+C).","cut":"قص","cutError":"الإعدادات الأمنية للمتصفح الذي تستخدمه تمنع القص التلقائي. فضلاً إستخدم لوحة المفاتيح لفعل ذلك (Ctrl/Cmd+X).","paste":"لصق","pasteNotification":"اضغط %1 للصق. اللصق عن طريق شريط الادوات او القائمة غير مدعوم من المتصفح المستخدم من قبلك.","pasteArea":"منطقة اللصق","pasteMsg":"الصق المحتوى بداخل المساحة المخصصة ادناه ثم اضغط على OK","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"تلقائي","bgColorTitle":"لون الخلفية","colors":{"000":"أسود","800000":"كستنائي","8B4513":"بني فاتح","2F4F4F":"رمادي أردوازي غامق","008080":"أزرق مخضر","000080":"أزرق داكن","4B0082":"كحلي","696969":"رمادي داكن","B22222":"طوبي","A52A2A":"بني","DAA520":"ذهبي داكن","006400":"أخضر داكن","40E0D0":"فيروزي","0000CD":"أزرق متوسط","800080":"بنفسجي غامق","808080":"رمادي","F00":"أحمر","FF8C00":"برتقالي داكن","FFD700":"ذهبي","008000":"أخضر","0FF":"تركواز","00F":"أزرق","EE82EE":"بنفسجي","A9A9A9":"رمادي شاحب","FFA07A":"برتقالي وردي","FFA500":"برتقالي","FFFF00":"أصفر","00FF00":"ليموني","AFEEEE":"فيروزي شاحب","ADD8E6":"أزرق فاتح","DDA0DD":"بنفسجي فاتح","D3D3D3":"رمادي فاتح","FFF0F5":"وردي فاتح","FAEBD7":"أبيض عتيق","FFFFE0":"أصفر فاتح","F0FFF0":"أبيض مائل للأخضر","F0FFFF":"سماوي","F0F8FF":"لبني","E6E6FA":"أرجواني","FFF":"أبيض","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"بنفسجي غامق","2C3E50":"Desaturated Blue","F39C12":"برتقالي","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"رمادي فاتح","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"فضي","7F8C8D":"Grayish Cyan","999":"رمادي غامق"},"more":"ألوان إضافية...","panelTitle":"Colors","textColorTitle":"لون النص"},"colordialog":{"clear":"مسح","highlight":"تحديد","options":"اختيارات الألوان","selected":"اللون المختار","title":"اختر اللون"},"templates":{"button":"القوالب","emptyListMsg":"(لم يتم تعريف أي قالب)","insertOption":"استبدال المحتوى","options":"خصائص القوالب","selectPromptMsg":"اختر القالب الذي تود وضعه في المحرر","title":"قوالب المحتوى"},"contextmenu":{"options":"خصائص قائمة السياق"},"copyformatting":{"label":"نسخ التنسيق","notification":{"copied":"تم نسخ التنسيق","applied":"تم تطبيق التنسيق","canceled":"تم الغاء التنسيق","failed":"Formatting failed. You cannot apply styles without copying them first."}},"div":{"IdInputLabel":"هوية","advisoryTitleInputLabel":"عنوان التقرير","cssClassInputLabel":"فئات التنسيق","edit":"تحرير Div","inlineStyleInputLabel":"Inline Style","langDirLTRLabel":"اليسار لليمين (LTR)","langDirLabel":"إتجاه النص","langDirRTLLabel":"اليمين لليسار (RTL)","languageCodeInputLabel":"رمز اللغة","remove":"إزالة Div","styleSelectLabel":"نمط","title":"إحداث Div Container","toolbar":"إحداث Div Container"},"elementspath":{"eleLabel":"مسار العنصر","eleTitle":"عنصر 1%"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Error occurred during file read.","networkError":"Network error occurred during file upload.","httpError404":"HTTP error occurred during file upload (404: File not found).","httpError403":"HTTP error occurred during file upload (403: Forbidden).","httpError":"HTTP error occurred during file upload (error status: %1).","noUrlError":"Upload URL is not defined.","responseError":"Incorrect server response."},"find":{"find":"بحث","findOptions":"Find Options","findWhat":"البحث بـ:","matchCase":"مطابقة حالة الأحرف","matchCyclic":"مطابقة دورية","matchWord":"مطابقة بالكامل","notFoundMsg":"لم يتم العثور على النص المحدد.","replace":"إستبدال","replaceAll":"إستبدال الكل","replaceSuccessMsg":"تم استبدال 1% من الحالات ","replaceWith":"إستبدال بـ:","title":"بحث واستبدال"},"font":{"fontSize":{"label":"حجم الخط","voiceLabel":"حجم الخط","panelTitle":"حجم الخط"},"label":"خط","panelTitle":"حجم الخط","voiceLabel":"حجم الخط"},"fakeobjects":{"anchor":"إرساء","hiddenfield":"إدراج حقل خفي","iframe":"iframe","unknown":"عنصر غير معروف"},"forms":{"button":{"title":"خصائص زر الضغط","text":"القيمة/التسمية","type":"نوع الزر","typeBtn":"زر","typeSbm":"إرسال","typeRst":"إعادة تعيين"},"checkboxAndRadio":{"checkboxTitle":"خصائص خانة الإختيار","radioTitle":"خصائص زر الخيار","value":"القيمة","selected":"محدد","required":"Required"},"form":{"title":"خصائص النموذج","menu":"خصائص النموذج","action":"اسم الملف","method":"الأسلوب","encoding":"تشفير"},"hidden":{"title":"خصائص الحقل المخفي","name":"الاسم","value":"القيمة"},"select":{"title":"خصائص اختيار الحقل","selectInfo":"اختار معلومات","opAvail":"الخيارات المتاحة","value":"القيمة","size":"الحجم","lines":"الأسطر","chkMulti":"السماح بتحديدات متعددة","required":"Required","opText":"النص","opValue":"القيمة","btnAdd":"إضافة","btnModify":"تعديل","btnUp":"أعلى","btnDown":"أسفل","btnSetValue":"إجعلها محددة","btnDelete":"إزالة"},"textarea":{"title":"خصائص مساحة النص","cols":"الأعمدة","rows":"الصفوف"},"textfield":{"title":"خصائص مربع النص","name":"الاسم","value":"القيمة","charWidth":"عرض السمات","maxChars":"اقصى عدد للسمات","required":"Required","type":"نوع المحتوى","typeText":"نص","typePass":"كلمة مرور","typeEmail":"بريد إلكتروني","typeSearch":"بحث","typeTel":"رقم الهاتف","typeUrl":"الرابط"}},"format":{"label":"تنسيق","panelTitle":"تنسيق الفقرة","tag_address":"عنوان","tag_div":"عادي (DIV)","tag_h1":"العنوان 1","tag_h2":"العنوان  2","tag_h3":"العنوان  3","tag_h4":"العنوان  4","tag_h5":"العنوان  5","tag_h6":"العنوان  6","tag_p":"عادي","tag_pre":"منسّق"},"horizontalrule":{"toolbar":"خط فاصل"},"iframe":{"border":"إظهار حدود الإطار","noUrl":"فضلا أكتب رابط الـ iframe","scrolling":"تفعيل أشرطة الإنتقال","title":"خصائص iframe","toolbar":"iframe","tabindex":"Remove from tabindex"},"image":{"alt":"عنوان الصورة","border":"سمك الحدود","btnUpload":"أرسلها للخادم","button2Img":"هل تريد تحويل زر الصورة المختار إلى صورة بسيطة؟","hSpace":"تباعد أفقي","img2Button":"هل تريد تحويل الصورة المختارة إلى زر صورة؟","infoTab":"معلومات الصورة","linkTab":"الرابط","lockRatio":"تناسق الحجم","menu":"خصائص الصورة","resetSize":"إستعادة الحجم الأصلي","title":"خصائص الصورة","titleButton":"خصائص زر الصورة","upload":"رفع","urlMissing":"عنوان مصدر الصورة مفقود","vSpace":"تباعد عمودي","validateBorder":"الإطار يجب أن يكون عددا","validateHSpace":"HSpace يجب أن يكون عدداً.","validateVSpace":"VSpace يجب أن يكون عدداً."},"indent":{"indent":"زيادة المسافة البادئة","outdent":"إنقاص المسافة البادئة"},"smiley":{"options":"خصائص الإبتسامات","title":"إدراج ابتسامات","toolbar":"ابتسامات"},"language":{"button":"حدد اللغة","remove":"حذف اللغة"},"link":{"acccessKey":"مفاتيح الإختصار","advanced":"متقدم","advisoryContentType":"نوع التقرير","advisoryTitle":"عنوان التقرير","anchor":{"toolbar":"إشارة مرجعية","menu":"تحرير الإشارة المرجعية","title":"خصائص الإشارة المرجعية","name":"اسم الإشارة المرجعية","errorName":"الرجاء كتابة اسم الإشارة المرجعية","errorWhitespace":"Anchor name cannot contain space characters","remove":"إزالة الإشارة المرجعية"},"anchorId":"حسب رقم العنصر","anchorName":"حسب إسم الإشارة المرجعية","charset":"ترميز المادة المطلوبة","cssClasses":"فئات التنسيق","download":"فرض التحميل","displayText":"نص العرض","emailAddress":"البريد الإلكتروني","emailBody":"محتوى الرسالة","emailSubject":"موضوع الرسالة","id":"هوية","info":"معلومات الرابط","langCode":"رمز اللغة","langDir":"إتجاه نص اللغة","langDirLTR":"اليسار لليمين (LTR)","langDirRTL":"اليمين لليسار (RTL)","menu":"تحرير الرابط","name":"إسم","noAnchors":"(لا توجد علامات مرجعية في هذا المستند)","noEmail":"الرجاء كتابة الريد الإلكتروني","noUrl":"الرجاء كتابة رابط الموقع","noTel":"Please type the phone number","other":"<أخرى>","phoneNumber":"Phone number","popupDependent":"تابع (Netscape)","popupFeatures":"خصائص النافذة المنبثقة","popupFullScreen":"ملئ الشاشة (IE)","popupLeft":"التمركز لليسار","popupLocationBar":"شريط العنوان","popupMenuBar":"القوائم الرئيسية","popupResizable":"قابلة التشكيل","popupScrollBars":"أشرطة التمرير","popupStatusBar":"شريط الحالة","popupToolbar":"شريط الأدوات","popupTop":"التمركز للأعلى","rel":"العلاقة","selectAnchor":"اختر علامة مرجعية","styles":"نمط","tabIndex":"الترتيب","target":"هدف الرابط","targetFrame":"<إطار>","targetFrameName":"اسم الإطار المستهدف","targetPopup":"<نافذة منبثقة>","targetPopupName":"اسم النافذة المنبثقة","title":"رابط","toAnchor":"مكان في هذا المستند","toEmail":"بريد إلكتروني","toUrl":"الرابط","toPhone":"Phone","toolbar":"رابط","type":"نوع الربط","unlink":"إزالة رابط","upload":"رفع"},"list":{"bulletedlist":"ادخال/حذف تعداد نقطي","numberedlist":"ادخال/حذف تعداد رقمي"},"liststyle":{"bulletedTitle":"Bulleted List Properties","circle":"Circle","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disc","lowerAlpha":"Lower Alpha (a, b, c, d, e, etc.)","lowerRoman":"Lower Roman (i, ii, iii, iv, v, etc.)","none":"None","notset":"<not set>","numberedTitle":"Numbered List Properties","square":"Square","start":"Start","type":"Type","upperAlpha":"Upper Alpha (A, B, C, D, E, etc.)","upperRoman":"Upper Roman (I, II, III, IV, V, etc.)","validateStartNumber":"List start number must be a whole number."},"magicline":{"title":"إدراج فقرة هنا"},"maximize":{"maximize":"تكبير","minimize":"تصغير"},"newpage":{"toolbar":"صفحة جديدة"},"pagebreak":{"alt":"فاصل الصفحة","toolbar":"إدخال صفحة جديدة"},"pastetext":{"button":"لصق كنص بسيط","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"لصق كنص بسيط"},"pastefromword":{"confirmCleanup":"يبدو أن النص المراد لصقه منسوخ من برنامج وورد. هل تود تنظيفه قبل الشروع في عملية اللصق؟","error":"لم يتم مسح المعلومات الملصقة لخلل داخلي","title":"لصق من وورد","toolbar":"لصق من وورد"},"preview":{"preview":"معاينة الصفحة"},"print":{"toolbar":"طباعة"},"removeformat":{"toolbar":"إزالة التنسيقات"},"save":{"toolbar":"حفظ"},"selectall":{"toolbar":"تحديد الكل"},"showblocks":{"toolbar":"مخطط تفصيلي"},"sourcearea":{"toolbar":"المصدر"},"specialchar":{"options":"خيارات الأحرف الخاصة","title":"اختر حرف خاص","toolbar":"إدراج  حرف خاص"},"scayt":{"btn_about":"عن SCAYT","btn_dictionaries":"قواميس","btn_disable":"تعطيل SCAYT","btn_enable":"تفعيل SCAYT","btn_langs":"لغات","btn_options":"خيارات","text_title":"تدقيق إملائي أثناء الكتابة"},"stylescombo":{"label":"أنماط","panelTitle":"أنماط التنسيق","panelTitle1":"أنماط الفقرة","panelTitle2":"أنماط مضمنة","panelTitle3":"أنماط الكائن"},"table":{"border":"الحدود","caption":"الوصف","cell":{"menu":"خلية","insertBefore":"إدراج خلية قبل","insertAfter":"إدراج خلية بعد","deleteCell":"حذف خلية","merge":"دمج خلايا","mergeRight":"دمج لليمين","mergeDown":"دمج للأسفل","splitHorizontal":"تقسيم الخلية أفقياً","splitVertical":"تقسيم الخلية عمودياً","title":"خصائص الخلية","cellType":"نوع الخلية","rowSpan":"امتداد الصفوف","colSpan":"امتداد الأعمدة","wordWrap":"التفاف النص","hAlign":"محاذاة أفقية","vAlign":"محاذاة رأسية","alignBaseline":"خط القاعدة","bgColor":"لون الخلفية","borderColor":"لون الحدود","data":"بيانات","header":"عنوان","columnHeader":"Column Header","rowHeader":"Row Header","yes":"نعم","no":"لا","invalidWidth":"عرض الخلية يجب أن يكون عدداً.","invalidHeight":"ارتفاع الخلية يجب أن يكون عدداً.","invalidRowSpan":"امتداد الصفوف يجب أن يكون عدداً صحيحاً.","invalidColSpan":"امتداد الأعمدة يجب أن يكون عدداً صحيحاً.","chooseColor":"اختر"},"cellPad":"المسافة البادئة","cellSpace":"تباعد الخلايا","column":{"menu":"عمود","insertBefore":"إدراج عمود قبل","insertAfter":"إدراج عمود بعد","deleteColumn":"حذف أعمدة"},"columns":"أعمدة","deleteTable":"حذف الجدول","headers":"العناوين","headersBoth":"كلاهما","headersColumn":"العمود الأول","headersNone":"بدون","headersRow":"الصف الأول","heightUnit":"height unit","invalidBorder":"حجم الحد يجب أن يكون عدداً.","invalidCellPadding":"المسافة البادئة يجب أن تكون عدداً","invalidCellSpacing":"المسافة بين الخلايا يجب أن تكون عدداً.","invalidCols":"عدد الأعمدة يجب أن يكون عدداً أكبر من صفر.","invalidHeight":"ارتفاع الجدول يجب أن يكون عدداً.","invalidRows":"عدد الصفوف يجب أن يكون عدداً أكبر من صفر.","invalidWidth":"عرض الجدول يجب أن يكون عدداً.","menu":"خصائص الجدول","row":{"menu":"صف","insertBefore":"إدراج صف قبل","insertAfter":"إدراج صف بعد","deleteRow":"حذف صفوف"},"rows":"صفوف","summary":"الخلاصة","title":"خصائص الجدول","toolbar":"جدول","widthPc":"بالمئة","widthPx":"بكسل","widthUnit":"وحدة العرض"},"undo":{"redo":"إعادة","undo":"تراجع"},"widget":{"move":"إضغط و إسحب للتحريك","label":"%1 widget"},"uploadwidget":{"abort":"Upload aborted by the user.","doneOne":"File successfully uploaded.","doneMany":"Successfully uploaded %1 files.","uploadOne":"Uploading file ({percentage}%)...","uploadMany":"Uploading files, {current} of {max} done ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"المصدر","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"المصدر","title":"المصدر"}};